#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/CAMAC/DAQBuilderCAMACModuleChannel.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CAMACModuleChannel ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CAMACModuleChannel ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CAMACModuleChannel");
    /*Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);*/

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_read;
    a_read.setMethodName("read");
    a_read.setReturnTypeName("DataElement");
    aClass.setMethod(a_read);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	//instance  = new CAMACModuleChannel(instance._objectName);
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CAMACModuleChannel*)instance._heldObject)->toString());
      }
    else if(methodName=="update")
      {
	((CAMACModuleChannel*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((CAMACModuleChannel*)instance.get())->clear();
      }
    else if(methodName=="initialize")
      {
	((CAMACModuleChannel*)instance.get())->initialize();
      }
    else if(methodName=="read")
      {
        DataElement aElement = ((CAMACModuleChannel*)instance.get())->read();
	aInstance= aElement;
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
