#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/CAMAC/DAQBuilderCAMACOutputRegister.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <Exception/DAQBuilderException.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CAMACOutputRegister ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CAMACOutputRegister ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CAMACOutputRegister");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("CAMACCrateController","Controller") );
    a_new.setArgumentsTypes( std::pair<DString,DString>("Integer","SlotNumber") );
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_waitInterrupt;
    a_waitInterrupt.setMethodName("waitInterrupt");
    a_waitInterrupt.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Waitting Time [microsec]") );
    a_waitInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_waitInterrupt);

    Method a_search;
    a_search.setMethodName("search");
    a_search.setArgumentsTypes( std::pair<DString,DString>("String","ChannelName") );
    a_search.setReturnTypeName("CAMACModuleChannel");
    aClass.setMethod(a_search);
    
    Method a_enableInterrupt;
    a_enableInterrupt.setMethodName("enableInterrupt");
    a_enableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_enableInterrupt);

    Method a_disableInterrupt;
    a_disableInterrupt.setMethodName("disableInterrupt");
    a_disableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_disableInterrupt);

    Method a_writeLevel;
    a_writeLevel.setMethodName("writeLevel");
    a_writeLevel.setArgumentsTypes( std::pair<DString,DString>("Number","WriteData") );
    a_writeLevel.setReturnTypeName("void");
    aClass.setMethod(a_writeLevel);

    Method a_writePulse;
    a_writePulse.setMethodName("writePulse");
    a_writePulse.setArgumentsTypes( std::pair<DString,DString>("Number","WriteData") );
    a_writePulse.setReturnTypeName("void");
    aClass.setMethod(a_writePulse);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new CAMACOutputRegister( (CAMACCrateController*)arguments[0].get(),
					     ((UnsignedLong*)arguments[1].get())->get(),
					     instance._objectName);
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CAMACOutputRegister*)instance._heldObject)->toString());
      }
    else if(methodName=="update")
      {
	((CAMACOutputRegister*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((CAMACOutputRegister*)instance.get())->clear();
      }
    else if(methodName=="initialize")
      {
	((CAMACOutputRegister*)instance.get())->initialize();
      }
    else if(methodName=="waitInterrupt")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACOutputRegister*)instance.get())->waitInterrupt( aElement);
      }
    else if(methodName=="search")
      {
        aInstance    = (Object*)(&((CAMACOutputRegister*)instance.get())->search((arguments[0].get())->toString()));
      }
    else if(methodName=="enableInterrupt")
      {
	((CAMACOutputRegister*)instance.get())->enableInterrupt();
      }
    else if(methodName=="disableInterrupt")
      {
	((CAMACOutputRegister*)instance.get())->disableInterrupt();
      }
    else if(methodName=="writeLevel")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACOutputRegister*)instance.get())->writeLevel(aElement);
      }
    else if(methodName=="writePulse")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACOutputRegister*)instance.get())->writePulse(aElement);
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
