#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/CAMAC/DAQBuilderCAMACSwitchRegister.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <Exception/DAQBuilderException.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CAMACSwitchRegister ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CAMACSwitchRegister ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CAMACSwitchRegister");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("CAMACCrateController","Controller") );
    a_new.setArgumentsTypes( std::pair<DString,DString>("Integer","SlotNumber") );
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_waitInterrupt;
    a_waitInterrupt.setMethodName("waitInterrupt");
    a_waitInterrupt.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Waitting Time [microsec]") );
    a_waitInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_waitInterrupt);

    Method a_write;
    a_write.setMethodName("write");
    a_write.setArgumentsTypes( std::pair<DString,DString>("Number","WriteData") );
    a_write.setReturnTypeName("void");
    aClass.setMethod(a_write);

    Method a_read;
    a_read.setMethodName("read");
    a_read.setReturnTypeName("DataElement");
    aClass.setMethod(a_read);

    Method a_readSwitch;
    a_readSwitch.setMethodName("readSwitch");
    a_readSwitch.setReturnTypeName("DataElement");
    aClass.setMethod(a_readSwitch);

    Method a_enableInterrupt;
    a_enableInterrupt.setMethodName("enableInterrupt");
    a_enableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_enableInterrupt);

    Method a_disableInterrupt;
    a_disableInterrupt.setMethodName("disableInterrupt");
    a_disableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_disableInterrupt);

    Method a_search;
    a_search.setMethodName("search");
    a_search.setArgumentsTypes( std::pair<DString,DString>("String","ChannelName") );
    a_search.setReturnTypeName("CAMACModuleChannel");
    aClass.setMethod(a_search);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new CAMACSwitchRegister( (CAMACCrateController*)arguments[0].get(),
					     ((Integer*)arguments[1].get())->get(),
					     instance._objectName);
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CAMACSwitchRegister*)instance._heldObject)->toString());
      }
    else if(methodName=="update")
      {
	((CAMACSwitchRegister*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((CAMACSwitchRegister*)instance.get())->clear();
      }
    else if(methodName=="initialize")
      {
	((CAMACSwitchRegister*)instance.get())->initialize();
      }
    else if(methodName=="waitInterrupt")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACSwitchRegister*)instance.get())->waitInterrupt( aElement);
      }
    else if(methodName=="write")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACSwitchRegister*)instance.get())->write(aElement);
      }
    else if(methodName=="read")
      {
        aInstance =
	  new DataElement(((CAMACSwitchRegister*)instance.get())->read());
      }
    else if(methodName=="readSwitch")
      {
        aInstance =
	  new DataElement(((CAMACSwitchRegister*)instance.get())->readSwitch());
      }
    else if(methodName=="search")
      {
        aInstance    = (Object*)(&((CAMACSwitchRegister*)instance.get())->search((arguments[0].get())->toString()));
      }
    else if(methodName=="enableInterrupt")
      {
	((CAMACSwitchRegister*)instance.get())->enableInterrupt();
      }
    else if(methodName=="disableInterrupt")
      {
	((CAMACSwitchRegister*)instance.get())->disableInterrupt();
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
