#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/CAMAC/DAQBuilderCAMACTDC.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <Exception/DAQBuilderException.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CAMACTDC ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CAMACTDC ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CAMACTDC");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("CAMACCrateController","Controller") );
    a_new.setArgumentsTypes( std::pair<DString,DString>("Integer","SlotNumber") );
    a_new.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Number of Channels") );
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_waitInterrupt;
    a_waitInterrupt.setMethodName("waitInterrupt");
    a_waitInterrupt.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Waitting Time [microsec]") );
    a_waitInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_waitInterrupt);

    Method a_search;
    a_search.setMethodName("search");
    a_search.setArgumentsTypes( std::pair<DString,DString>("String","ChannelName") );
    a_search.setReturnTypeName("CAMACModuleChannel");
    aClass.setMethod(a_search);
    
    Method a_enableInterrupt;
    a_enableInterrupt.setMethodName("enableInterrupt");
    a_enableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_enableInterrupt);

    Method a_disableInterrupt;
    a_disableInterrupt.setMethodName("disableInterrupt");
    a_disableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_disableInterrupt);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new CAMACTDC( (CAMACCrateController*)arguments[0].get(),
	                          ((Integer*)arguments[1].get())->get(),
	                          ((UnsignedLong*)arguments[2].get())->get(),
				 instance._objectName);
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CAMACTDC*)instance._heldObject)->toString());
      }
    else if(methodName=="update")
      {
	((CAMACTDC*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((CAMACTDC*)instance.get())->clear();
      }
    else if(methodName=="initialize")
      {
	((CAMACTDC*)instance.get())->initialize();
      }
    else if(methodName=="waitInterrupt")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((CAMACTDC*)instance.get())->waitInterrupt( aElement);
      }
    else if(methodName=="search")
      {
        aInstance    = (Object*)(&((CAMACTDC*)instance.get())->search((arguments[0].get())->toString()));
      }
    else if(methodName=="enableInterrupt")
      {
	((CAMACTDC*)instance.get())->enableInterrupt();
      }
    else if(methodName=="disableInterrupt")
      {
	((CAMACTDC*)instance.get())->disableInterrupt();
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
