#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <Modules/DAQBuilderReadoutList.hh>
#include <DAQBuilderSerializeDataGettableObject.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : ReadoutList ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : ReadoutList ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("ReadoutList");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_read;
    a_read.setMethodName("read");
    a_read.setReturnTypeName("DataSection");
    aClass.setMethod(a_read);

    Method a_getDataRecord;
    a_getDataRecord.setMethodName("getDataRecord");
    a_getDataRecord.setReturnTypeName("DataRecord");
    aClass.setMethod(a_getDataRecord);

    Method a_installSource;
    a_installSource.setMethodName("installSource");
    a_installSource.setArgumentsTypes( std::pair<DString,DString>("SerializeDataGettableObject","Source") );
    a_installSource.setReturnTypeName("void");
    aClass.setMethod(a_installSource);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new ReadoutList();
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((ReadoutList*)instance._heldObject)->toString());
      }
    else if(methodName=="getDataRecord")
      {
	aInstance = new DataRecord(((ReadoutList*)instance.get())->getDataRecord());
      }
    else if(methodName=="read")
      {
	aInstance = new DataSection(((ReadoutList*)instance.get())->read());
      }
    else if(methodName=="installSource")
      {
	//((ReadoutList*)instance.get())->installSource(*((SerializeDataGettableObject*)arguments[0].get()));
	((ReadoutList*)instance.get())->installSource((SerializeDataGettableObject*)arguments[0].get());
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
