#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/DAQBuilderSoftwareSwitchRegister.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <Exception/DAQBuilderException.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : SoftwareSwitchRegister ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : SoftwareSwitchRegister ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("SoftwareSwitchRegister");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Number of Channels") );
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_waitInterrupt;
    a_waitInterrupt.setMethodName("waitInterrupt");
    a_waitInterrupt.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","Waitting Time [microsec]") );
    a_waitInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_waitInterrupt);

    Method a_search;
    a_search.setMethodName("search");
    a_search.setArgumentsTypes( std::pair<DString,DString>("String","ChannelName") );
    a_search.setReturnTypeName("ModuleChannel");
    aClass.setMethod(a_search);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new SoftwareSwitchRegister(instance._objectName,((UnsignedLong*)arguments[0].get())->get());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((SoftwareSwitchRegister*)instance._heldObject)->toString());
      }
    else if(methodName=="update")
      {
	((SoftwareSwitchRegister*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((SoftwareSwitchRegister*)instance.get())->clear();
      }
    else if(methodName=="initialize")
      {
	((SoftwareSwitchRegister*)instance.get())->initialize();
      }
    else if(methodName=="waitInterrupt")
      {
        DataElement aElement = ((UnsignedLong*)arguments[0].get())->get();
	((SoftwareSwitchRegister*)instance.get())->waitInterrupt( aElement);
      }
    else if(methodName=="search")
      {
        aInstance    = (Object*)(&((SoftwareSwitchRegister*)instance.get())->search((arguments[0].get())->toString()));
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
