#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : String ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : String ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("String");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("String","Initialize") );

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");


    aClass.setMethod(a_new);
    aClass.setMethod(a_toString);
    
    instance._class = aClass;
  }

 void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
         DString aString = arguments[0]->toString();
         instance  = aString;
      }
    else if(methodName=="toString")
      {
         aInstance = new String(((String*)instance._heldObject)->toString());
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
