#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderBufferedOutputStream.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : BufferedOutputStream ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : BufferedOutputStream ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("BufferedOutputStream");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setArgumentsTypes( std::pair<DString,DString>("OutputStream","Wrapped output stream"));
    a_new.setArgumentsTypes( std::pair<DString,DString>("UnsignedLong","BuffereSize"));
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isBuffered )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isBuffered)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
				     arguments);
    
    if(methodName=="new")
      {
	instance  = new BufferedOutputStream((OutputStream*)arguments[0].get(),((UnsignedLong*)arguments[1].get())->get());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((BufferedOutputStream*)instance._heldObject)->toString());
      }
  }
}
extern "C"{
  void   execute( DAQBuilder::Instance&      instance ,
		  const DAQBuilder::DString& methodName ,
		  DAQBuilder::Arguments&     arguments,
		  DAQBuilder::Instance&     returnValue,
		  const   DAQBuilder::DBool&   isBuffered )
    throw(DAQBuilder::Exception *)
  {
    return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isBuffered);
  }
  DAQBuilder::Instance  getInstance()
  {
    DAQBuilder::Instance  aInstance;
    DAQBuilder::makeClass(aInstance);
    return  aInstance; 
  }
}
