#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderNumber.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderCheckedInputStream.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CheckedInputStream ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CheckedInputStream ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CheckedInputStream");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setArgumentsTypes( std::pair<DString,DString>("InputStream","Wrapped output stream"));
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_read;
    a_read.setMethodName("read");
    a_read.setReturnTypeName("SerializableObject");
    aClass.setMethod(a_read);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isChecked )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
				     arguments);
    
    if(methodName=="new")
      {
	instance  = new CheckedInputStream((InputStream*)arguments[0].get());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CheckedInputStream*)instance._heldObject)->toString());
      }
    else if(methodName=="read")
      {
        aInstance = ((CheckedInputStream*)instance.get())->readObject();
      }
  }
}
extern "C"{
  void   execute( DAQBuilder::Instance&      instance ,
		  const DAQBuilder::DString& methodName ,
		  DAQBuilder::Arguments&     arguments,
		  DAQBuilder::Instance&     returnValue,
		  const   DAQBuilder::DBool&   isChecked )
    throw(DAQBuilder::Exception *)
  {
    return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
  }
  DAQBuilder::Instance  getInstance()
  {
    DAQBuilder::Instance  aInstance;
    DAQBuilder::makeClass(aInstance);
    return  aInstance; 
  }
}
