#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderNumber.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderCheckedOutputStream.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CheckedOutputStream ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CheckedOutputStream ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CheckedOutputStream");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setArgumentsTypes( std::pair<DString,DString>("OutputStream","Wrapped output stream"));
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);
    
    Method a_write;
    a_write.setMethodName("write");
    a_write.setArgumentsTypes( std::pair<DString,DString>("SerializableObject","Write Object to Stream "));
    a_write.setReturnTypeName("void");
    aClass.setMethod(a_write);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isChecked )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
				     arguments);
    
    if(methodName=="new")
      {
	instance  = new CheckedOutputStream((OutputStream*)arguments[0].get());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CheckedOutputStream*)instance._heldObject)->toString());
      }
    else if(methodName=="write")
      {
        ((CheckedOutputStream*)instance.get())->write((SerializableObject*)arguments[0].get());
      }
  }
}
extern "C"{
  void   execute( DAQBuilder::Instance&      instance ,
		  const DAQBuilder::DString& methodName ,
		  DAQBuilder::Arguments&     arguments,
		  DAQBuilder::Instance&     returnValue,
		  const   DAQBuilder::DBool&   isChecked )
    throw(DAQBuilder::Exception *)
  {
    return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
  }
  DAQBuilder::Instance  getInstance()
  {
    DAQBuilder::Instance  aInstance;
    DAQBuilder::makeClass(aInstance);
    return  aInstance; 
  }
}
