#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderNumber.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderGZipOutputStream.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : GZipOutputStream ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : GZipOutputStream ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("GZipOutputStream");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setArgumentsTypes( std::pair<DString,DString>("OutputStream","Wrapped output stream"));
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isGZip )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isGZip)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
				     arguments);
    
    if(methodName=="new")
      {
	instance  = new GZipOutputStream((OutputStream*)arguments[0].get());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((GZipOutputStream*)instance._heldObject)->toString());
      }
  }
}
extern "C"{
  void   execute( DAQBuilder::Instance&      instance ,
		  const DAQBuilder::DString& methodName ,
		  DAQBuilder::Arguments&     arguments,
		  DAQBuilder::Instance&     returnValue,
		  const   DAQBuilder::DBool&   isGZip )
    throw(DAQBuilder::Exception *)
  {
    return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isGZip);
  }
  DAQBuilder::Instance  getInstance()
  {
    DAQBuilder::Instance  aInstance;
    DAQBuilder::makeClass(aInstance);
    return  aInstance; 
  }
}
