#define  D_USE_GTK
#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Util/DAQBuilderClock.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : Clock ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : Clock ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("Clock");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");


    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");

    Method a_show;
    a_show.setMethodName("show");
    a_show.setReturnTypeName("void");

    aClass.setMethod(a_new);
    aClass.setMethod(a_toString);
    aClass.setMethod(a_show);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isChecked )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new Clock();
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((Clock*)instance._heldObject)->toString());
      }
    else if(methodName=="show")
      {
        ((Clock*)instance.get())->show();
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
