#include <Modules/CAMAC/DAQBuilderCAMACADC.hh>
#include <Modules/DAQBuilderModuleChannel.hh>
#include <DataRecord/DAQBuilderDataElement.hh>

namespace DAQBuilder
{
  DBool   CAMACADC::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACADC*)o));
  }
  DBool   CAMACADC::equals( const CAMACADC& o ) const 
  {
    return true;
  }
    CAMACADC::CAMACADC( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&  _numChannels,
		 const DString& _moduleName ,
		 const DBool&   _is16BitModule
		 )
    :CAMACModule(controller,_slotNumber,_numChannels,_is16BitModule,_moduleName)
  {
    _setType();
    _setParentClasses();
  }
  CAMACADC::CAMACADC( const CAMACADC& right )
    :CAMACModule(*((CAMACModule*)&right))
  {
  }
  CAMACADC::~CAMACADC()
  {
  }
  const CAMACADC&  CAMACADC::operator=( const CAMACADC& right )
  {
    *((CAMACModule*)this)= *((CAMACModule*)&right);
    return *this;
  }
}
