#ifndef __DAQBuilderCAMACADC_HH_
#define __DAQBuilderCAMACADC_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>

namespace DAQBuilder
{
  class CAMACADC: public CAMACModule
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACADC& o ) const ;
    CAMACADC( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&  _numChannels,
		 const DString& _moduleName = "NoModuleName",
		 const DBool&   _is16BitModule = true 
		 );
    CAMACADC( const CAMACADC& right );
    virtual  ~CAMACADC();
    virtual const CAMACADC&  operator=( const CAMACADC& right );
  };
  inline void CAMACADC::_setType()
  {
    _type ="CAMACADC";
  }
  inline void CAMACADC::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
    _parentClasses.insert("CAMACModule");
  }

}
#endif
