#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Util/DAQBuilderMatcher.hh>
namespace DAQBuilder
{
  void              CAMACCrateController::_finalize()
  {
   close();
  }
  DBool  CAMACCrateController::equals( const Object * o ) const 
  {
       if(!findParent(_type,o))
	 return false;
       return equals( *((CAMACCrateController*)o));
  }
  DBool  CAMACCrateController::equals( const CAMACCrateController& o ) const 
  {
    DBool aBool = (_deviceNodeName == o._deviceNodeName );
   aBool       |= (_fd == o._fd );
   return aBool;
  }
  const DString        CAMACCrateController::toString() const
  {
    DString aString="DeviceNodeName : ";
    aString       +=_deviceNodeName;
    aString       +="\n";
    aString       +="FileDescripter : ";
    aString       +=String::digitToString((DLong)_fd);
    aString       +="\n";
    aString       +="isOpen         : ";
    isOpen()?
     aString       += "true" :
     aString       += "false" ;
    return aString;
  }
  CAMACCrateController::CAMACCrateController( const DString& deviceNodeName)
    :ModuleController(),_deviceNodeName(deviceNodeName),_fd(-1)
  {
    _setType();
    _setParentClasses();
  }
  CAMACCrateController::CAMACCrateController( const CAMACCrateController& right )
    :ModuleController(*((ModuleController*)&right)),_deviceNodeName(right._deviceNodeName),_fd(right._fd)
  {
  }
  CAMACCrateController::~CAMACCrateController()
  {
    _finalize();
  }
  const CAMACCrateController& CAMACCrateController::operator=( const CAMACCrateController& right )
  {
    *((ModuleController*)this) = *((ModuleController*)&right); 
   _deviceNodeName              =  right._deviceNodeName;
   _fd                          =  right._fd;
    return *this;
  }

  void CAMACCrateController::setDeviceNodeName( const DString& _deviceNodeName)
    throw( CAMACModuleException * )
  {
    this->_deviceNodeName = _deviceNodeName;
    close();
    open();
  }
  DBool CAMACCrateController::isISAcc7000() const
  {
    Pattern  p = Pattern::compile( "\\/dev\\/ISAcc[0-9]+\\.[0-9]");
    Matcher  m = p.matcher(_deviceNodeName);
    return m.matches();
  }
  DBool CAMACCrateController::isPCIcc7700() const
  {
    Pattern  p = Pattern::compile( "\\/dev\\/PCIcc[0-9]+\\.[0-9]");
    Matcher  m = p.matcher(_deviceNodeName);
    return m.matches();
  }
  void CAMACCrateController::open() 
    throw( CAMACModuleException * )
  { 
    _fd = CAMACFunctions::open( _deviceNodeName );
  }
  void CAMACCrateController::close() 
    throw( CAMACModuleException * )
  {
    CAMACFunctions::close( _fd );
    _fd = -1;
  }
  DBool CAMACCrateController::isOpen() const 
  {
    CAMACFunctions::clearErrorNumber();
    return _fd != -1;
  }
  DBool CAMACCrateController::isOnline() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::isOnline( _fd );
  }
  void CAMACCrateController::reset() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::reset( _fd );
  }
  void CAMACCrateController::initialize() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::initialize( _fd );
  }
  void CAMACCrateController::update() const 
    throw( CAMACModuleException * )
  {
  if(!isOpen())
    throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::update( _fd );
  }
  void CAMACCrateController::clear() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::clear( _fd );
  }
  
  void CAMACCrateController::enableInterrupt() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::enableInterrupt( _fd );
  }
  void CAMACCrateController::disableInterrupt() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::disableInterrupt( _fd );
  }
  void CAMACCrateController::enableOwnInterrupt() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::enableOwnInterrupt( _fd );
  }
  void CAMACCrateController::disableOwnInterrupt() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::disableOwnInterrupt( _fd );
  }
  void CAMACCrateController::setCrateID( DInt id ) const 
    throw( CAMACModuleException * )
  {
  if(!isOpen())
    throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::setCrateID( _fd , id );
  }
  void CAMACCrateController::basslineOff() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::basslineOff( _fd );
  }
  void CAMACCrateController::basslineOn() const 
    throw( CAMACModuleException * )
  {
    if(!isOpen())
      throw new CAMACModuleException(" Is Not Open Device "+_deviceNodeName);
    return CAMACFunctions::basslineOn( _fd );
  }
}
