#ifndef __DAQBuilderCAMACCrateController_HH_
#define __DAQBuilderCAMACCrateController_HH_
#include <Modules/DAQBuilderModuleController.hh>
#include <Exception/DAQBuilderCAMACModuleException.hh>

namespace DAQBuilder
{
  class CAMACModuleChannel;
  class CAMACModule;
  class CAMACCrateController :  public ModuleController
  {
    friend class CAMACModuleChannel;
    friend class CAMACModule;
  private:
    DString         _deviceNodeName;
    FileDescriptor  _fd;
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const CAMACCrateController& o ) const ;
    CAMACCrateController( const DString& _deviceNodeName );
    CAMACCrateController( const CAMACCrateController& right );
    virtual ~CAMACCrateController();
    virtual const CAMACCrateController& operator=( const CAMACCrateController& right );
  public:
    virtual const DString        toString() const;
    void setDeviceNodeName( const DString& _deviceNodeName)
      throw( CAMACModuleException * );
    DBool isISAcc7000() const;
    DBool isPCIcc7700() const;
  public:
    void open() 
      throw( CAMACModuleException * );
    void close() 
      throw( CAMACModuleException * );
    DBool isOpen() const ;
    DBool isOnline() const 
    throw( CAMACModuleException * );
   public:
    void reset() const 
      throw( CAMACModuleException * );
    void initialize() const 
      throw( CAMACModuleException * );
    void update() const 
      throw( CAMACModuleException * );
    void clear() const 
      throw( CAMACModuleException * );
    void enableInterrupt() const 
      throw( CAMACModuleException * );
    void disableInterrupt() const 
      throw( CAMACModuleException * );
    void enableOwnInterrupt() const 
      throw( CAMACModuleException * );
    void disableOwnInterrupt() const 
      throw( CAMACModuleException * );
    void setCrateID( DInt id ) const 
      throw( CAMACModuleException * );
    void basslineOn() const 
      throw( CAMACModuleException * );
    void basslineOff() const 
      throw( CAMACModuleException * );
  };
  inline void CAMACCrateController::_setType()
  {
    _type ="CAMACCrateController";
  }
  inline void CAMACCrateController::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("ModuleController");
  }
}
#endif
