#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#define CC7x00_IOC_MAGIC	0xcc

#define IOC_GET_VERSION _IOR(CC7x00_IOC_MAGIC,  0x00, unsigned*)
#define IOC_GET_CONFIG	_IOR(CC7x00_IOC_MAGIC,  0x01, union IOmapCC7x00)
#define IOC_TEST_ONLINE _IO(CC7x00_IOC_MAGIC,   0x02)
#define IOC_RESET_CRATE	_IO(CC7x00_IOC_MAGIC,	0x03)
#define IOC_SET_Z	_IO(CC7x00_IOC_MAGIC,	0x04)
#define IOC_SET_C	_IO(CC7x00_IOC_MAGIC,	0x05)
#define IOC_SET_I	_IO(CC7x00_IOC_MAGIC,	0x06)
#define IOC_RESET_I	_IO(CC7x00_IOC_MAGIC,	0x07)
#define IOC_SET_EI	_IO(CC7x00_IOC_MAGIC,	0x08)
#define IOC_RESET_EI	_IO(CC7x00_IOC_MAGIC,	0x09)
#define IOC_SET_LI	_IO(CC7x00_IOC_MAGIC,	0x0a)
#define IOC_RESET_LI	_IO(CC7x00_IOC_MAGIC,	0x0b)
#define IOC_SET_CN	_IOW(CC7x00_IOC_MAGIC,	0x0c, unsigned)
#define IOC_WAIT_LAM	_IOW(CC7x00_IOC_MAGIC,	0x0d, unsigned**)
#define IOC_GET_LAM	_IOR(CC7x00_IOC_MAGIC,	0x0e, unsigned*)
#define IOC_CAM16       _IOR(CC7x00_IOC_MAGIC,  0x0f, struct YasuDriverInterface)
#define IOC_CAM24       _IOR(CC7x00_IOC_MAGIC,  0x10, struct YasuDriverInterface)
 
namespace DAQBuilder
{
  typedef struct YasuDriverInterface
  {
    DUInt  _naf;
    DShort _q;
    DShort _x;
    union DataPartOfCAMACData
    {
      DUShort _d16;
      DUInt   _d24;
    }_data;
    
  };
  DBool  CAMACFunctions::equals( const Object * o ) const 
  {
       if(!findParent(_type,o))
	 return false;
       return equals( *((CAMACFunctions*)o));
  }
  DBool  CAMACFunctions::equals( const CAMACFunctions& o ) const 
  {
    return true;
  }
  CAMACFunctions::CAMACFunctions()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  CAMACFunctions::CAMACFunctions( const CAMACFunctions& right )
    :Object(*((Object*)&right))
  {
  }
  CAMACFunctions::~CAMACFunctions()
  {
  }
  const CAMACFunctions& CAMACFunctions::operator=( const CAMACFunctions& right )
  {
    *((Object*)this)=    *((Object*)&right);
    return *this;
  }
  const DString CAMACFunctions::toString() const 
  {
    DString aString;
    return aString;
  } 
   void           CAMACFunctions::clearErrorNumber()
  {
    errno ^= errno;
  }
  
   DataElement    CAMACFunctions::executeNAF(  const FileDescriptor& fd , 
	                                       const DInt&           stationNumber , 
					       const DInt&           subAddress , 
					       const DInt&           function , 
					       const DBool&          isISAcc7000  , 
					       const DBool&          is16BitModuleChannel , 
					       const DataElement&    data )
    throw(CAMACModuleException *)
  {
    DataElement aElement=0;
    DUInt naf = 0;
    DInt  chan= subAddress;
    if( isISAcc7000)
      naf =((function & 0x001f) << 16) + (( chan & 0x000f)<<8) + ( stationNumber & 0x001f) ;
    else
      naf =(((stationNumber-1)&0x001f)<<9) + (( chan & 0x000f)<<5) + ( function & 0x0000001f);

    struct YasuDriverInterface ydi;
    //bzero(&ydi,sizeof(ydi));
    ydi._naf=naf;
    ydi._q  = 0 ;
    ydi._x  = 0 ;
    CAMACFunctions::clearErrorNumber();
    if(is16BitModuleChannel){
      ydi._data._d16= data.getUShort();
      ioctl( fd , IOC_CAM16 , &ydi );
      aElement=(DUShort)ydi._data._d16;
    }
    else{
      ydi._data._d24= data.getUInt();
      ioctl( fd , IOC_CAM24 , &ydi );
      aElement= (DUInt)ydi._data._d24;
    }
    if(!ydi._q && errno!=0){
      throw new CAMACModuleException(strerror(errno),"Can't recieve command ");
    }
    if(!ydi._x && errno !=0 ){
      throw new CAMACModuleException(strerror(errno),"Can't execute");
    }
    if(errno!=0){
      throw new CAMACModuleException(strerror(errno),"");
    }
    return aElement;
  }
  
   FileDescriptor  CAMACFunctions::open( const DString& deviceNodeName )
    throw(CAMACModuleException *)
  {
    CAMACFunctions::clearErrorNumber();
    FileDescriptor fd = ::open( deviceNodeName.c_str(), O_RDWR );
    if( fd < 0 )
      {
	DString location = "void CAMACCrateController::open()";
	DString message  = "libcamlib: Open fail ";
	message             += deviceNodeName;
	message             += "\n";
	switch(errno)
	  {
	  case EBADR :
	    message   +="  Invalid minor number error. It is bug of the driver.\n";
	    break;
	  case ENOENT :
	    message   += "  You may not have made device node or give invalid. device node name.\n";
	    message   += "  Did you execute 'make node' command in top directory\n  with root permission ?\n";
	    message   += "  Did you give invalid device node name(";
	    message   += deviceNodeName;
	    message   +=") ?\n";
	    break;
	  case EPERM :
	    message   += "  This device is not supported by driver.\n";
	    break;
	  case EBUSY:
	    message   += "  Device is already used by another process.\n";
	    break;
	  case EAGAIN:
	    message   += "  I/O or IRQ number is already used by another process.\n";
	    message   += "  The driver couldn't get I/O or IRQ resource.\n";
	    break;
	  case ENODEV:
	    message   += "  ENODEV error is returned.\n Did you install module(cc7x00.o) DInto kernel ?\n";
	    message   += "  Did you execute 'insmod cc7x00.o' or 'make inst'\n";
	    message   += "  command with root permission ?\n";
	    break;
	  default:
	    message   += "  Unexpected error occured";
	    break;
	  }
	throw new CAMACModuleException( location , message );
      }
    return fd;
  }
  
   void            CAMACFunctions::close( const FileDescriptor& fd )
    throw(CAMACModuleException *)
  {
    CAMACFunctions::clearErrorNumber();
    if(fd!=-1)
      {
	if(::close( fd ) == -1 )
	  {
	    DString location = "void CAMACCrateController::close()";
	    DString message  = " Close fail ";
	    message             += "\n";
	    switch(errno)
	      {
	      case EBADF :
		message   +="  Invalid fd \n";
		break;
	      case EINTR :
		message   += "  Interrupt Catched .\n";
		break;
	      case EIO :
		message   += "  IO Error Occured.\n";
		break;
	      default:
		message   += "  Unexpected error occured";
		break;
	      }
	    throw new CAMACModuleException( location , message );
	  }
      }
  }
  
   DBool CAMACFunctions::isOnline(  const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    return  ::ioctl( fd ,IOC_TEST_ONLINE ) >= 0;
  }
  
   void CAMACFunctions::reset( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_RESET_CRATE ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't reset");
    }

  }  
   void CAMACFunctions::initialize( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_Z ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't initialize");
    }
  }
  
   void CAMACFunctions::update( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_C ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't update");
    }
  }
  
   void CAMACFunctions::clear( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_C ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't clear");
    }
  }

   void CAMACFunctions::enableInterrupt( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_EI ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't enable Interrupt ");
    }
  }  

   void CAMACFunctions::disableInterrupt( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_RESET_EI ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't disable Interrupt ");
    }
  }
  
   void CAMACFunctions::enableOwnInterrupt( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_LI ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't enable Own Interrupt ");
    }
  }
    
   void CAMACFunctions::disableOwnInterrupt( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_RESET_LI ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't disable Own Interrupt ");
    }
  }
  
   void CAMACFunctions::setCrateID(  const FileDescriptor& fd , const DInt& id )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_CN, id  ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't set ID ");
    }
  }
   void CAMACFunctions::waitInterrupt( const FileDescriptor& fd , const DInt& stationNumber , const DataElement& waitTime )
    throw( CAMACModuleException * )
  {
    DInt aMilliSecond = waitTime.getInt();
    DUInt timeout = (DUInt)( (DDouble)HZ/(DDouble)1000 * (DDouble)aMilliSecond );
    DUInt mask = ( 1 << ( stationNumber  - 1 ) );
    DUInt buffer[ 2 ] = { timeout, ~mask };
    CAMACFunctions::clearErrorNumber();
    ioctl( fd , IOC_WAIT_LAM, &buffer);
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't wait Interrupt ");
    }
  }

   DataElement CAMACFunctions::readLookAtMe( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    DUInt  camacData=0;
    ioctl(fd , IOC_GET_LAM,&camacData);
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't read Look at me  ");
    }
    return camacData;
  } 
   void CAMACFunctions::basslineOn( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_SET_I  ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't be on bassline ");
    }
  }
  
   void CAMACFunctions::basslineOff( const FileDescriptor& fd )
    throw( CAMACModuleException * )
  {
    CAMACFunctions::clearErrorNumber();
    ioctl( fd ,IOC_RESET_I  ) ;
    if( errno != 0){
      throw new CAMACModuleException(strerror(errno),"Can't be on bassline ");
    }
  }
}
