#ifndef __DAQBuilderCAMACFunctions_HH_
#define __DAQBuilderCAMACFunctions_HH_
#include <Exception/DAQBuilderCAMACModuleException.hh>
namespace DAQBuilder
{
  class DataElement;
  class CAMACFunctions : public Object
  {
  public:
    enum{Read              = 0,
	   Write           = 16,
	   Clear           = 9,
	   TestInterrupt   = 8,
	   ClearInterrupt  = 10,
	   EnableInterrupt = 26,
	   DisableInterrupt= 24
	   };
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const CAMACFunctions& o ) const ;
    CAMACFunctions();
    CAMACFunctions( const CAMACFunctions& right );
    virtual ~CAMACFunctions();
    virtual const CAMACFunctions& operator=( const CAMACFunctions& right );
  public:
    static void           clearErrorNumber();
    static DataElement    executeNAF( const FileDescriptor& fd , const DInt& stationNumber , const DInt& subAddress , const DInt& function , 
				      const DBool& isISAcc7000  , const DBool& is16BitModuleChannel , const DataElement& data )
      throw(CAMACModuleException *);

    static FileDescriptor  open( const DString& deviceNodeName )
      throw(CAMACModuleException *);
    
    static void            close( const FileDescriptor& fd )
      throw(CAMACModuleException *);
    
    static DBool isOnline(  const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void reset( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void initialize( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void update( const FileDescriptor& fd )
    throw( CAMACModuleException * );
    
    static void clear( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void enableInterrupt( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void disableInterrupt( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void enableOwnInterrupt( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    static void disableOwnInterrupt( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void setCrateID(  const FileDescriptor& fd , const DInt& id )
      throw( CAMACModuleException * );
    
    static void basslineOn( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
    static void basslineOff( const FileDescriptor& fd )
      throw( CAMACModuleException * );

    static void waitInterrupt( const FileDescriptor& fd , const DInt& stationNumber ,const DataElement& waitTime )
      throw( CAMACModuleException * );

    static DataElement readLookAtMe( const FileDescriptor& fd )
      throw( CAMACModuleException * );
    
  public :
    const DString toString() const;
  };
  inline void CAMACFunctions::_setType()
  {
    _type ="CAMACFunctions";
  }
  inline void CAMACFunctions::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("ControlledFunctions");
  }
}
#endif
