#include <Modules/CAMAC/DAQBuilderCAMACInterruptRegister.hh>
#include <Modules/CAMAC/DAQBuilderCAMACInterruptRegisterChannel.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  DBool   CAMACInterruptRegister::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACInterruptRegister*)o));
  }
  DBool   CAMACInterruptRegister::equals( const CAMACInterruptRegister& o ) const 
  {
    return true;
  }
    CAMACInterruptRegister::CAMACInterruptRegister( CAMACCrateController* controller , 
                 const DInt&    slotNumber,
		 const DULong&  numChan,
		 const DString& moduleName ,
		 const DBool&   is16BitModule
		 )
    :CAMACModule(controller,slotNumber,0,is16BitModule,moduleName)
  {
    _setType();
    _setParentClasses();
    _numChannels=numChan;
    for( DULong i =  0 ;  i< _numChannels ; i ++)
      {
        installChannel( *((ModuleChannel*) new CAMACInterruptRegisterChannel(controller,slotNumber,is16BitModule,String::digitToString(i))));
      }
  }
  CAMACInterruptRegister::CAMACInterruptRegister( const CAMACInterruptRegister& right )
    :CAMACModule(*((CAMACModule*)&right))
  {
  }
  CAMACInterruptRegister::~CAMACInterruptRegister()
  {
  }
  const CAMACInterruptRegister&  CAMACInterruptRegister::operator=( const CAMACInterruptRegister& right )
  {
    *((CAMACModule*)this)= *((CAMACModule*)&right);
    return *this;
  }
  void CAMACInterruptRegister::setEffective( const DString& channel )
      throw (ModuleException * )
  {
    return ((CAMACInterruptRegisterChannel&)search(channel)).setEffective();
  }
  void CAMACInterruptRegister::unsetEffective( const DString& channel )
     throw (ModuleException * )
  {
    return ((CAMACInterruptRegisterChannel&)search(channel)).unsetEffective();
  }
  DBool CAMACInterruptRegister::isEffective( const DString& channel )
     throw (ModuleException * )
  {
    return ((CAMACInterruptRegisterChannel&)search(channel)).isEffective();
  }
  void   CAMACInterruptRegister::clearMask()
    throw( CAMACModuleException * )
  {
    _executeNAF(11,0);
  }
  void   CAMACInterruptRegister:: initialize()
    throw( CAMACModuleException * )
  {
    clear();
    clearMask();
    disableInterrupt();
  }
  void   CAMACInterruptRegister:: enableInterruptOutput()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::EnableInterrupt,1);
  }
  void   CAMACInterruptRegister:: disableInterruptOutput()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::DisableInterrupt,1);
  }
}
