#ifndef __DAQBuilderCAMACInterruptRegister_HH_
#define __DAQBuilderCAMACInterruptRegister_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>

namespace DAQBuilder
{
  class CAMACInterruptRegister: public CAMACModule
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACInterruptRegister& o ) const ;
    CAMACInterruptRegister( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&    _numChan,
		 const DString& _moduleName = "NoModuleName",
		 const DBool&   _is16BitModule = true 
		 );
    CAMACInterruptRegister( const CAMACInterruptRegister& right );
    virtual  ~CAMACInterruptRegister();
    virtual const CAMACInterruptRegister&  operator=( const CAMACInterruptRegister& right );
    public:
  void setEffective( const DString& channel )
      throw (ModuleException * );
  void unsetEffective( const DString& channel )
     throw (ModuleException * );
  DBool isEffective( const DString& channel )
     throw (ModuleException * );
  virtual       void  clearMask()
          throw( CAMACModuleException * );
  virtual       void  initialize()
          throw( CAMACModuleException * );

  virtual void    enableInterruptOutput()
          throw( CAMACModuleException * );
  virtual void    disableInterruptOutput()
          throw( CAMACModuleException * );
  };
  inline void CAMACInterruptRegister::_setType()
  {
    _type ="CAMACInterruptRegister";
  }
  inline void CAMACInterruptRegister::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
    _parentClasses.insert("CAMACModule");
  }

}
#endif
