#include <Modules/CAMAC/DAQBuilderCAMACInterruptRegisterChannel.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
 
namespace DAQBuilder
{
  DBool  CAMACInterruptRegisterChannel::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACInterruptRegisterChannel*)o));
  }
  DBool  CAMACInterruptRegisterChannel::equals( const CAMACInterruptRegisterChannel& o ) const 
  {
    return true;
  }
  CAMACInterruptRegisterChannel::CAMACInterruptRegisterChannel( CAMACCrateController* controller , 
								const DInt&  slotNumber,
								const DBool& is16BitModuleChannel, 
								const DString& moduleName)
    :CAMACModuleChannel(controller,slotNumber,is16BitModuleChannel,moduleName)
  {
    _setType();
    _setParentClasses();
  }
  CAMACInterruptRegisterChannel::CAMACInterruptRegisterChannel( const CAMACInterruptRegisterChannel& right )
    :CAMACModuleChannel( *((CAMACInterruptRegisterChannel*)&right))
  {
  }
  CAMACInterruptRegisterChannel::~CAMACInterruptRegisterChannel()
  {
  }
  const CAMACInterruptRegisterChannel& CAMACInterruptRegisterChannel::operator=( const CAMACInterruptRegisterChannel& right )
  {
    *((CAMACModuleChannel*)this)  =  *((CAMACModuleChannel*)&right);
       return *this;
  }
  void  CAMACInterruptRegisterChannel::setEffective() 
       throw (CAMACModuleException *)
  {
    if(isEffective()) 
      return ;
    DInt mask = _executeNAF(1,0,0).getInt();
    mask      = ~mask;
    mask     -=  1 << (atoi(_name.c_str())-1); 
    mask      = ~mask;
    _executeNAF(CAMACFunctions::Write,1,0);
  }
  void  CAMACInterruptRegisterChannel::unsetEffective() 
       throw (CAMACModuleException *)
  {
    if(!isEffective()) 
      return ;
    DInt mask = _executeNAF(1,0,0).getInt();
    mask      = ~mask;
    mask     +=  1 << (atoi(_name.c_str())-1); 
    mask      = ~mask;
    _executeNAF(CAMACFunctions::Write,1,0);
  }
  DBool CAMACInterruptRegisterChannel::isEffective() 
       throw (CAMACModuleException *)
  {
    DInt mask = _executeNAF(1,0,0).getInt();
    DInt tmpMask = 1 << (atoi(_name.c_str())-1); 
    mask = ~mask;
    return (mask&tmpMask)==1; 
  }
  DataElement CAMACInterruptRegisterChannel::read()
      throw (CAMACModuleException * )
  {
     DInt data = _executeNAF(CAMACFunctions::Read,1,0).getInt();
     if(!isEffective())
        return false;
    DInt tmpMask = 1 << (atoi(_name.c_str())-1); 
    return (data&tmpMask)==1; 
  }
}
