#ifndef __DAQBuilderCAMACInterruptRegisterChannel_HH_
#define __DAQBuilderCAMACInterruptRegisterChannel_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModuleChannel.hh>
#include <Exception/DAQBuilderCAMACModuleException.hh>
 
namespace DAQBuilder
{
  class CAMACInterruptRegisterChannel : public CAMACModuleChannel
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const CAMACInterruptRegisterChannel& o ) const ;
    CAMACInterruptRegisterChannel( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
		 const DBool&  _is16BitInterruptRegisterChannel = true, 
		 const DString& _moduleName = "NoInterruptRegisterChannelName" );
    CAMACInterruptRegisterChannel( const CAMACInterruptRegisterChannel& right );
    virtual ~CAMACInterruptRegisterChannel();
    virtual const CAMACInterruptRegisterChannel& operator=( const CAMACInterruptRegisterChannel& right );
    public:
     void  setEffective() 
       throw (CAMACModuleException *);
     void  unsetEffective() 
       throw (CAMACModuleException *);
     DBool isEffective() 
       throw (CAMACModuleException *);
     virtual DataElement read()
      throw (CAMACModuleException * );
  };
  inline void CAMACInterruptRegisterChannel::_setType()
  {
    _type ="CAMACInterruptRegisterChannel";
  }
  inline void CAMACInterruptRegisterChannel::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("ControlledModuleChannel");
    _parentClasses.insert("CAMACModuleChannel");
  }
}
#endif
