#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>
#include <Modules/CAMAC/DAQBuilderCAMACModuleChannel.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  DBool  CAMACModule:: equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACModule*)o));
  }
  DBool  CAMACModule:: equals( const CAMACModule& right ) const 
  {
    DBool aBool = _is16BitModule         == right._is16BitModule;
    aBool      |= _slotNumber             == right._slotNumber;
    aBool      |= _numChannels            == right._numChannels;
    return aBool;
  }
  DataElement CAMACModule::_executeNAF( const DInt& function , const DataElement& data , const DInt& channel )
    throw( CAMACModuleException *)
  {
    if(!((CAMACCrateController*)_moduleController.get())->isOpen())
      ((CAMACCrateController*)_moduleController.get())->open();
    return CAMACFunctions::executeNAF(((CAMACCrateController*)_moduleController.get())->_fd,_slotNumber, channel , function ,
                                      ((CAMACCrateController*)_moduleController.get())->isISAcc7000(), _is16BitModule , data ); 
  }
  CAMACModule:: CAMACModule( CAMACCrateController* controller , 
			     const DInt&    slotNumber,
			     const DULong&  numChannels,
			     const DBool& is16BitModule ,
			     const DString& moduleName )
    :ControlledModule(controller,moduleName),_is16BitModule(is16BitModule),
    _slotNumber(slotNumber),_numChannels(numChannels)
  {
    _setType();
    _setParentClasses();
    for( DULong i =  0 ;  i< _numChannels ; i ++)
      {
        installChannel( *((ModuleChannel*) new CAMACModuleChannel(controller,slotNumber,is16BitModule,String::digitToString(i))));
      }
  }
  CAMACModule:: CAMACModule( const CAMACModule& right )
    :ControlledModule(*((ControlledModule*)&right)),_is16BitModule(right._is16BitModule),
    _slotNumber(right._slotNumber),_numChannels(right._numChannels)
  {
  }
  CAMACModule:: ~CAMACModule()
  {
  }
  const CAMACModule& CAMACModule:: operator=( const CAMACModule& right )
  {
    *((ControlledModule*)this)=*((ControlledModule*)&right);
    _is16BitModule          = right._is16BitModule;
    _slotNumber             = right._slotNumber;
    _numChannels            = right._numChannels;
    return *this;
  }
  void   CAMACModule:: clear()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::Clear,0);
  }
  void   CAMACModule:: update()
    throw( CAMACModuleException * )
  {
    clear();
  }
  void   CAMACModule:: initialize()
    throw( CAMACModuleException * )
  {
    clear();
    disableInterrupt();
  }
  void         CAMACModule:: waitInterrupt( const DataElement& waitTime  )
    throw( CAMACModuleException * )
  {
    if(!((CAMACCrateController*)_moduleController.get())->isOpen())
      ((CAMACCrateController*)_moduleController.get())->open();
    try{
      CAMACFunctions::waitInterrupt( ((CAMACCrateController*)_moduleController.get())->_fd,_slotNumber,waitTime);
    }catch(CAMACModuleException * e ){
      delete e;
    }
    return ;
  }
  DataElement  CAMACModule:: readLookAtMe()
    throw( CAMACModuleException * )
  {
    if(!((CAMACCrateController*)_moduleController.get())->isOpen())
        ((CAMACCrateController*)_moduleController.get())->open();
    return CAMACFunctions::readLookAtMe( ((CAMACCrateController*)_moduleController.get())->_fd );
  }
  void   CAMACModule:: testInterrupt()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::TestInterrupt,0);
  }
  void   CAMACModule:: clearInterrupt()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::ClearInterrupt,0);
  }
  void   CAMACModule:: enableInterrupt()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::EnableInterrupt,0);
  }
  void   CAMACModule:: disableInterrupt()
    throw( CAMACModuleException * )
  {
    _executeNAF(CAMACFunctions::DisableInterrupt,0);
  }
  const DString               CAMACModule::toString() const
  {
    DString aString = "ModuleName    : ";
    aString        += _name;
    aString        += "\n";
    aString        += "SlotNumber    : ";
    aString        += String::digitToString((DLong)_slotNumber);
    aString        += "\n";
    aString        += "is16BitModule : ";
    _is16BitModule ? 
               aString        += "true" :
               aString        += "false";
    aString        += "\n";
    aString        += "CrateContoller: ";
    aString        += _moduleController->toString();
    aString        += "\n(";
    for( std::map<DString,SmartPointer>::const_iterator iter = begin() ;
         iter != end();
         iter++)
      {
        aString        += (iter->second).toString();
        aString        += "\n";
      }
    aString += ")";
    return aString;
  }
}
