#ifndef __DAQBuilderCAMACModule_HH_
#define __DAQBuilderCAMACModule_HH_
#include <Modules/DAQBuilderControlledModule.hh>
#include <Exception/DAQBuilderCAMACModuleException.hh>

namespace DAQBuilder
{
  class DataElement;
  class CAMACCrateController;
  class CAMACModule: public ControlledModule
  {
  protected:
    DBool   _is16BitModule;
    DInt    _slotNumber;
    DULong  _numChannels;
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DataElement           _executeNAF( const DInt& function , const DataElement& data , const DInt& channel = 0 )
      throw( CAMACModuleException * );
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACModule& o ) const ;
     CAMACModule( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&  _numChannels,
		 const DBool& _is16BitModule = true, 
		 const DString& _moduleName = "NoModuleName" );
     CAMACModule( const CAMACModule& right );
    virtual  ~CAMACModule();
    virtual const CAMACModule&  operator=( const CAMACModule& right );
  public:
    virtual       void  clear()
          throw( CAMACModuleException * );
    virtual       void  update()
          throw( CAMACModuleException * );
    virtual       void  initialize()
          throw( CAMACModuleException * );
    virtual void          waitInterrupt( const DataElement& waitTime  )
          throw( CAMACModuleException * );
    virtual DataElement   readLookAtMe()
          throw( CAMACModuleException * );
  public:
    virtual void    testInterrupt()
          throw( CAMACModuleException * );
    virtual void    clearInterrupt()
          throw( CAMACModuleException * );
    virtual void    enableInterrupt()
          throw( CAMACModuleException * );
    virtual void    disableInterrupt()
          throw( CAMACModuleException * );
  public:
  void           setSlotNumber( const DInt& slotNumber ) ;
  const DInt&    getSlotNumber() const;
  DBool           is16BitModule() const ;    
  public:
    const DString toString() const;
  };
  inline void CAMACModule::_setType()
  {
    _type ="CAMACModule";
  }
  inline void CAMACModule::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
  }
  inline  void           CAMACModule::setSlotNumber( const DInt& slotNumber ) 
  { 
    _slotNumber = slotNumber;
  }
  inline  const DInt&    CAMACModule::getSlotNumber() const
  {
    return _slotNumber;
  }
  inline DBool           CAMACModule::is16BitModule() const     
   {
      return _is16BitModule;
   }
}
#endif
