#include <Modules/CAMAC/DAQBuilderCAMACModuleChannel.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
 
namespace DAQBuilder
{
  DataElement CAMACModuleChannel::_executeNAF( const DInt& function , const DataElement& data , DInt channel  )
    throw( CAMACModuleException *)
  {
    if(!((CAMACCrateController*)_moduleController.get())->isOpen())
        ((CAMACCrateController*)_moduleController.get())->open();

    if(channel < 0)  
      channel = atoi(_name.c_str()); 
    return CAMACFunctions::executeNAF(((CAMACCrateController*)_moduleController.get())->_fd,_slotNumber, channel , function ,
                                      ((CAMACCrateController*)_moduleController.get())->isISAcc7000(), _is16BitModuleChannel , data ); 
  }

  DBool  CAMACModuleChannel::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACModuleChannel*)o));
  }
  DBool  CAMACModuleChannel::equals( const CAMACModuleChannel& o ) const 
  {
    DBool aBool     = _slotNumber ==o._slotNumber;
    return aBool;
  }
  CAMACModuleChannel::CAMACModuleChannel( CAMACCrateController* controller , 
                                          const DInt&  slotNumber,
					  const DBool& is16BitModuleChannel, 
					  const DString& moduleName)
    :ControlledModuleChannel(controller,moduleName),
    _is16BitModuleChannel(is16BitModuleChannel),_slotNumber(slotNumber)
  {
    _setType();
    _setParentClasses();
  }
  CAMACModuleChannel::CAMACModuleChannel( const CAMACModuleChannel& right )
    :ControlledModuleChannel( *((ControlledModuleChannel*)&right)),
    _is16BitModuleChannel(right._is16BitModuleChannel),_slotNumber(right._slotNumber)
  {
  }
  CAMACModuleChannel::~CAMACModuleChannel()
  {
  }
  const CAMACModuleChannel& CAMACModuleChannel::operator=( const CAMACModuleChannel& right )
  {
    *((ControlledModuleChannel*)this)  =  *((ControlledModuleChannel*)&right);
    _is16BitModuleChannel = right._is16BitModuleChannel;
    _slotNumber           = right._slotNumber;
    return *this;
  }
  DataElement CAMACModuleChannel::read()
    throw (CAMACModuleException * )
  {
    DataElement data =  _executeNAF( CAMACFunctions::Read ,0); 
    data.setElementName(_name);
    return data;
  }
  void  CAMACModuleChannel::write( const DataElement&  element  )
      throw (CAMACModuleException * )
  {
    _executeNAF( CAMACFunctions::Write,element); 
    return ;
  }
}
