#ifndef __DAQBuilderCAMACModuleChannel_HH_
#define __DAQBuilderCAMACModuleChannel_HH_
#include <Modules/DAQBuilderControlledModuleChannel.hh>
#include <Exception/DAQBuilderCAMACModuleException.hh>
 
namespace DAQBuilder
{
  class DataElement;
  class CAMACCrateController;
  class CAMACModuleChannel : public ControlledModuleChannel
  {
  protected:
    DBool   _is16BitModuleChannel;
    DInt    _slotNumber;
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DataElement           _executeNAF( const DInt& function , const DataElement& data , DInt channel = -1)
      throw (CAMACModuleException * );
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const CAMACModuleChannel& o ) const ;
    CAMACModuleChannel( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
		 const DBool& _is16BitModuleChannel = true, 
		 const DString& _moduleName = "NoModuleChannelName" );
    CAMACModuleChannel( const CAMACModuleChannel& right );
    virtual ~CAMACModuleChannel();
    virtual const CAMACModuleChannel& operator=( const CAMACModuleChannel& right );
  public:
    virtual DataElement read()
      throw (CAMACModuleException * );
    virtual       void  write( const DataElement&  element  )
      throw (CAMACModuleException * );
  public:
    const DBool&          is16BitModuleChannel() const;     
  };
  inline void CAMACModuleChannel::_setType()
  {
    _type ="CAMACModuleChannel";
  }
  inline void CAMACModuleChannel::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("ModuleChannel");
    _parentClasses.insert("ControlledModuleChannel");
  }
  inline  const DBool&          CAMACModuleChannel::is16BitModuleChannel() const     
  {
    return _is16BitModuleChannel;
  }
}
#endif
