#include <Modules/CAMAC/DAQBuilderCAMACOutputRegister.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  DBool   CAMACOutputRegister::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACOutputRegister*)o));
  }
  DBool   CAMACOutputRegister::equals( const CAMACOutputRegister& o ) const 
  {
    return true;
  }
    CAMACOutputRegister::CAMACOutputRegister( CAMACCrateController* controller , 
                 const DInt&    slotNumber,
		 const DString& moduleName ,
		 const DBool&   is16BitModule
		 )
    :CAMACModule(controller,slotNumber,0,is16BitModule,moduleName)
  {
    _setType();
    _setParentClasses();
  }
  CAMACOutputRegister::CAMACOutputRegister( const CAMACOutputRegister& right )
    :CAMACModule(*((CAMACModule*)&right))
  {
  }
  CAMACOutputRegister::~CAMACOutputRegister()
  {
  }
  const CAMACOutputRegister&  CAMACOutputRegister::operator=( const CAMACOutputRegister& right )
  {
    *((CAMACModule*)this)= *((CAMACModule*)&right);
    return *this;
  }
  void   CAMACOutputRegister::writeLevel( const DataElement& data )
       throw ( CAMACModuleException  * )
  {
    _executeNAF(CAMACFunctions::Write,data);
  }

  void   CAMACOutputRegister::writePulse( const DataElement& data )
       throw ( CAMACModuleException  * )
  {
    _executeNAF(17,data);
  }
}
