#ifndef __DAQBuilderCAMACOutputRegister_HH_
#define __DAQBuilderCAMACOutputRegister_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>

namespace DAQBuilder
{
  class CAMACOutputRegister: public CAMACModule
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACOutputRegister& o ) const ;
    CAMACOutputRegister( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
		 const DString& _moduleName = "NoModuleName",
		 const DBool&   _is16BitModule = true 
		 );
    CAMACOutputRegister( const CAMACOutputRegister& right );
    virtual  ~CAMACOutputRegister();
    virtual const CAMACOutputRegister&  operator=( const CAMACOutputRegister& right );
    public:
      void   writeLevel( const DataElement& data )
       throw ( CAMACModuleException  * );
      void   writePulse( const DataElement& data )
       throw ( CAMACModuleException  * );
  };
  inline void CAMACOutputRegister::_setType()
  {
    _type ="CAMACOutputRegister";
  }
  inline void CAMACOutputRegister::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
    _parentClasses.insert("CAMACModule");
  }

}
#endif
