#include <Modules/CAMAC/DAQBuilderCAMACSwitchRegister.hh>
#include <Modules/CAMAC/DAQBuilderCAMACFunctions.hh>
#include <Modules/DAQBuilderModuleChannel.hh>
#include <DataRecord/DAQBuilderDataElement.hh>

namespace DAQBuilder
{
  DBool   CAMACSwitchRegister::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACSwitchRegister*)o));
  }
  DBool   CAMACSwitchRegister::equals( const CAMACSwitchRegister& o ) const 
  {
    return true;
  }
  CAMACSwitchRegister::CAMACSwitchRegister( CAMACCrateController* controller , 
					    const DInt&    _slotNumber,
					    const DString& _moduleName)
    :CAMACModule(controller,_slotNumber,2,false,_moduleName)
  {
    _setType();
    _setParentClasses();
  }
  CAMACSwitchRegister::CAMACSwitchRegister( const CAMACSwitchRegister& right )
    :CAMACModule(*((CAMACModule*)&right))
  {
  }
  CAMACSwitchRegister::~CAMACSwitchRegister()
  {
  }
  const CAMACSwitchRegister&  CAMACSwitchRegister::operator=( const CAMACSwitchRegister& right )
  {
    *((CAMACModule*)this)= *((CAMACModule*)&right);
    return *this;
  }
  const DataElement   CAMACSwitchRegister::read( const DString& num ) 
    throw(CAMACModuleException*)
  {
    return ((ModuleChannel&)search(num)).read();
  }
  const DataElement   CAMACSwitchRegister::readSwitch() 
    throw(CAMACModuleException*)
  {
    return ((ModuleChannel&)search("1")).read();
  }
  void          CAMACSwitchRegister::write( DataElement data )
    throw(CAMACModuleException*)
  {
    return ((ModuleChannel&)search("0")).write(data);
  }
  void  CAMACSwitchRegister::clear()
          throw( CAMACModuleException * )
	  {
	   clearInterrupt();
	   disableInterrupt();
           _executeNAF(CAMACFunctions::Clear,0);
	  }
}
