#ifndef __DAQBuilderCAMACSwitchRegister_HH_
#define __DAQBuilderCAMACSwitchRegister_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>

namespace DAQBuilder
{
  class CAMACSwitchRegister: public CAMACModule
  {
  protected:
    enum{ Lamp , Switch };
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACSwitchRegister& o ) const ;
    CAMACSwitchRegister( CAMACCrateController* controller , 
			 const DInt&    _slotNumber,
			 const DString& _moduleName = "NoSwitchRegisterName" );
    CAMACSwitchRegister( const CAMACSwitchRegister& right );
    virtual  ~CAMACSwitchRegister();
    virtual const CAMACSwitchRegister&  operator=( const CAMACSwitchRegister& right );
  public:
    const DataElement   read( const DString& num = "0") 
      throw(CAMACModuleException*);
    const DataElement   readSwitch() 
      throw(CAMACModuleException*);
    void          write( DataElement data )
      throw(CAMACModuleException*);
    virtual       void  clear()
          throw( CAMACModuleException * );
  };
  inline void CAMACSwitchRegister::_setType()
  {
    _type ="CAMACSwitchRegister";
  }
  inline void CAMACSwitchRegister::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
    _parentClasses.insert("CAMACModule");
  }

}
#endif
