#include <Modules/CAMAC/DAQBuilderCAMACTDC.hh>
#include <Modules/DAQBuilderModuleChannel.hh>
#include <DataRecord/DAQBuilderDataElement.hh>

namespace DAQBuilder
{
  DBool   CAMACTDC::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
      return false;
    return equals( *((CAMACTDC*)o));
  }
  DBool   CAMACTDC::equals( const CAMACTDC& o ) const 
  {
    return true;
  }
    CAMACTDC::CAMACTDC( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&  _numChannels,
		 const DString& _moduleName ,
		 const DBool&   _is16BitModule
		 )
    :CAMACModule(controller,_slotNumber,_numChannels,_is16BitModule,_moduleName)
  {
    _setType();
    _setParentClasses();
  }
  CAMACTDC::CAMACTDC( const CAMACTDC& right )
    :CAMACModule(*((CAMACModule*)&right))
  {
  }
  CAMACTDC::~CAMACTDC()
  {
  }
  const CAMACTDC&  CAMACTDC::operator=( const CAMACTDC& right )
  {
    *((CAMACModule*)this)= *((CAMACModule*)&right);
    return *this;
  }
}
