#ifndef __DAQBuilderCAMACTDC_HH_
#define __DAQBuilderCAMACTDC_HH_
#include <Modules/CAMAC/DAQBuilderCAMACModule.hh>

namespace DAQBuilder
{
  class CAMACTDC: public CAMACModule
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool   equals( const Object * o ) const ;
    virtual DBool   equals( const CAMACTDC& o ) const ;
    CAMACTDC( CAMACCrateController* controller , 
                 const DInt&    _slotNumber,
                 const DULong&  _numChannels,
		 const DString& _moduleName = "NoModuleName",
		 const DBool&   _is16BitModule = true 
		 );
    CAMACTDC( const CAMACTDC& right );
    virtual  ~CAMACTDC();
    virtual const CAMACTDC&  operator=( const CAMACTDC& right );
  };
  inline void CAMACTDC::_setType()
  {
    _type ="CAMACTDC";
  }
  inline void CAMACTDC::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("ControlledModule");
    _parentClasses.insert("CAMACModule");
  }

}
#endif
