#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/DAQBuilderControlledModule.hh>
#include <Modules/DAQBuilderModuleController.hh>
#include <Util/DAQBuilderRandomEngine.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{   
  DBool  ControlledModule::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
	 return false;
    return equals( *((ControlledModule*)o));
  }
  DBool  ControlledModule::equals( const ControlledModule& o ) const 
  {
    return  equals(o);
  }
  ControlledModule::ControlledModule( ModuleController* moduleController, const DString& moduleName )
    :Module(moduleName)
  {
    if(moduleController!=NULL)
     _moduleController = (Object*)moduleController;
    _setType();
    _setParentClasses();
  }
  ControlledModule::ControlledModule( const ControlledModule& right )
    :Module(*((Module*)&right)),_moduleController(right._moduleController)
  {    
  }
  ControlledModule::~ControlledModule()
  {
    _finalize();
  }
  const ControlledModule& ControlledModule::operator=( const ControlledModule& right )
  {
    *((Module*)this)  =    *((Module*)&right);
    _moduleController=right._moduleController;
    return *this;
  }
}

