#ifndef __DAQBuilderControlledModule_HH_
#define __DAQBuilderControlledModule_HH_
#include <Modules/DAQBuilderModule.hh>

namespace DAQBuilder
{
  class ModuleController;
  class ControlledModule : public Module
  {
  protected:
    SmartPointer               _moduleController;
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const ControlledModule& o ) const ;
    ControlledModule( ModuleController* _moduleController = NULL, const DString& _moduleName = "NoControlledModuleName");
    ControlledModule( const ControlledModule& right );
    virtual ~ControlledModule();
    virtual const ControlledModule& operator=( const ControlledModule& right );
  public:
  };
  inline void ControlledModule::_setType()
  {
    _type ="ControlledModule";
  }
  inline void ControlledModule::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
  }
}
#endif
