#include <Modules/DAQBuilderControlledModuleChannel.hh>
#include <Modules/DAQBuilderModuleController.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  void              ControlledModuleChannel::_finalize()
  {;}

  DBool  ControlledModuleChannel::equals( const Object * o ) const 
  {
       if(!findParent(_type,o))
	 return false;
       return equals( *((ControlledModuleChannel*)o));
  }
  DBool  ControlledModuleChannel::equals( const ControlledModuleChannel& o ) const 
  {
    return _moduleController.equals(o._moduleController);
  }
  ControlledModuleChannel::ControlledModuleChannel( ModuleController * moduleController , const DString& channelName )
    :ModuleChannel(channelName)
  {
    _setType();
    _setParentClasses();
    _moduleController = moduleController;
  }
  ControlledModuleChannel::ControlledModuleChannel( const ControlledModuleChannel& right )
    :ModuleChannel(*((ModuleChannel*)&right)),_moduleController(right._moduleController)
  {
  }
  ControlledModuleChannel::~ControlledModuleChannel()
  {
    _finalize();
  }
  const ControlledModuleChannel& ControlledModuleChannel::operator=( const ControlledModuleChannel& right )
  {
    *((ModuleChannel*)this) =      *((ModuleChannel*)&right); 
    _moduleController       =  right._moduleController;
    return *this;
  }
}
