#ifndef __DAQBuilderControlledModuleChannel_HH_
#define __DAQBuilderControlledModuleChannel_HH_
#include <Modules/DAQBuilderModuleChannel.hh>
#include <Util/DAQBuilderSmartPointer.hh>

namespace DAQBuilder
{
  class ModuleController;
  class ControlledModuleChannel : 
  public ModuleChannel
  {
  protected:
    SmartPointer               _moduleController;
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const ControlledModuleChannel& o ) const ;
    ControlledModuleChannel( ModuleController * _moduleController , const DString& _channelName ="NoChannelName");
    ControlledModuleChannel( const ControlledModuleChannel& right );
    virtual ~ControlledModuleChannel();
    virtual const ControlledModuleChannel& operator=( const ControlledModuleChannel& right );
  };
  inline void ControlledModuleChannel::_setType()
  {
    _type ="ControlledModuleChannel";
  }
  inline void ControlledModuleChannel::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("ModuleChannel");
  }
}
#endif
