#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/DAQBuilderModule.hh>
#include <Modules/DAQBuilderModuleChannel.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>

namespace DAQBuilder
{   
  void              Module::_finalize()
  {;}

  DBool  Module::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
	 return false;
    return equals( *((Module*)o));
  }
  DBool  Module::equals( const Module& o ) const 
  {
    if(size() != o.size() )
      return false;

    DBool aBool = _name == o._name;
      
  std::map<DString,SmartPointer>::const_iterator iterO = o.begin() ;
    for( std::map<DString,SmartPointer>::const_iterator iter = begin() ;
	 iter!= end() ;
	 iter++)
      {
        aBool |= ((ModuleChannel*)(iter->second).get())->equals( (iterO->second).get());
        iterO++;
      }
    return  aBool;
  }
  Module::Module( const DString& name )
    :SerializeDataGettableObject()
  {
    _setType();
    _setParentClasses();
    _name = name;
  }
  Module::Module( const Module& right )
    :SerializeDataGettableObject(*((SerializeDataGettableObject*)&right))
  {    
  }
  Module::~Module()
  {
    _finalize();
  }
  const Module& Module::operator=( const Module& right )
  {
    *((Object*)this) =    *((Object*)&right);
    _name            =  right._name;
    return *this;
  }
  const DString               Module::toString() const
  {
    DString aString = "ModuleName : ";
    aString        += _name;
    aString        += "\n(";
    for( std::map<DString,SmartPointer>::const_iterator iter = begin() ;
         iter != end();
         iter++)
      {
        aString        += (iter->second).toString();
        aString        += "\n";
      }
    aString += ")";
    return aString;
  }
  const StringList           Module::getStatus() const
  {
    StringList aStringList;
    for( std::map<DString,SmartPointer>::const_iterator iter = begin() ;
         iter != end();
         iter++)
      {
	aStringList.push_back(((ModuleChannel*)(iter->second).get())->getStatus());
      }
    return aStringList;
  }
  
  void Module::clear()
  {
    for( std::map<DString,SmartPointer>::iterator iter = begin() ;
         iter != end();
         iter++)
      {
	((ModuleChannel*)(iter->second).get())->clear();
      }
  }
  void Module::update()
  {
    for( std::map<DString,SmartPointer>::iterator iter = begin() ;
         iter != end();
         iter++)
      {
	((ModuleChannel*)(iter->second).get())->update();
      }
  }
  void Module::initialize()
  {
    for( std::map<DString,SmartPointer>::iterator iter = begin() ;
         iter != end();
         iter++)
      {
	((ModuleChannel*)(iter->second).get())->initialize();
      }
  }
  void  Module::write( const DataElement&  element  )
  {
    for( std::map<DString,SmartPointer>::iterator iter = begin() ;
         iter != end();
         iter++)
      {
	((ModuleChannel*)(iter->second).get())->write( element );
      }
  }
  void  Module::write( const DString& channel , const DataElement&  element  )
    throw( ModuleException *)
  {
    return ((ModuleChannel&)search(channel)).write(element);
  }
 
  const DataSegment Module::read()
  {
    DataSegment aSegment;
    aSegment.setSegmentName(_name);
    for( std::map<DString,SmartPointer>::iterator iter = begin() ;
         iter != end();
         iter++)
      {
	aSegment.insertData(((ModuleChannel*)(iter->second).get())->read());
      }
    return aSegment;
  }
  const DataElement Module::read( const DString& channel )
      throw (ModuleException * )
  {
    return ((ModuleChannel&)search(channel)).read();
  }
  void         Module::waitInterrupt( const DataElement& waitTime  )
  {
  }
  DataElement  Module::readLookAtMe()
  {
    return (DInt)1;
  }
  const ByteArray Module::getData()
  {
      ByteArrayOutputStream aBAO;
      ObjectOutputStream    aOOS(&aBAO);
      DataSegment aSegment = read();
      aOOS.writeObject(aSegment);
      return aBAO.toByteArray();
  }
  void                        Module::setStatus( const DString& channel , const DString& status )
  {
    ((ModuleChannel&)search(channel)).setStatus(status);
  }
  ModuleChannel&        Module::search( const DString& channelName )
    throw ( ModuleException * )
  {
    std::map<DString,SmartPointer>::iterator iter  = find(channelName);
    if(iter == end())
      throw new ModuleException("Module::seach(const DString) "+channelName);
    else
       return *((ModuleChannel*)(iter->second).get());
  }
  void                Module::installChannel( ModuleChannel & channel ) 
      throw (SameNameBindedException * )
   {
    DString channelName = channel.getName();
    std::map<DString,SmartPointer>::iterator iter  = find(channelName);
    if(iter != end())
      throw new SameNameBindedException("Module::installChannel(ModuleChannel& ) "+channelName);
    else
    {
       SmartPointer sp;
       sp  = channel;
       channel.setParentName(_name);
       insert(std::pair<DString,SmartPointer>(channelName,sp));
    }
   }
}

