#ifndef __DAQBuilderModule_HH_
#define __DAQBuilderModule_HH_
#include <DAQBuilderSerializeDataGettableObject.hh>
#include <Interface/DAQBuilderSerializeDataGettable.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <Exception/DAQBuilderModuleException.hh>
#include <Util/DAQBuilderSmartPointer.hh>

namespace DAQBuilder
{
  class DataSegment;
  class DataElement;
  class ModuleChannel;
  class Module : public std::map<DString,SmartPointer> 
  ,public SerializeDataGettableObject
  {
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const Module& o ) const ;
    Module( const DString& _moduleName = "NoModuleName");
    Module( const Module& right );
    virtual ~Module();
    virtual const Module& operator=( const Module& right );
  public:
    virtual       void clear();
    virtual       void update();
    virtual       void initialize();
    virtual const DataSegment read();
    virtual const DataElement read( const DString& channel )
      throw ( ModuleException * );
    virtual       void  write( const DataElement&  element  );
    virtual       void  write( const DString& channel , const DataElement&  element  )
      throw ( ModuleException * );
    virtual void         waitInterrupt( const DataElement& waitTime  );
    virtual DataElement  readLookAtMe();
  public:
    const DString               toString() const ;

    const StringList            getStatus() const;
    void                        setStatus( const DString& channel , const DString& status );

    ModuleChannel&              search( const DString& moduleName )
      throw (ModuleException * );
  
    virtual const ByteArray     getData();
    virtual void                installChannel( ModuleChannel & channel ) 
      throw (SameNameBindedException * );
  };
  inline void Module::_setType()
  {
    _type ="Module";
  }
  inline void Module::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
  }
}
#endif
