#include <Modules/DAQBuilderModuleChannel.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>

namespace DAQBuilder
{
  void              ModuleChannel::_finalize()
  {;}
  DBool  ModuleChannel::equals( const Object * o ) const 
  {
       if(!findParent(_type,o))
	 return false;
       return equals( *((ModuleChannel*)o));
  }
  DBool  ModuleChannel::equals( const ModuleChannel& o ) const 
  {
    DBool aBool = _status == o._status;
    aBool      |= _name    ==      o._name;
    aBool      |= _parentName     ==      o._parentName;
    return  aBool;
  }
  const DString        ModuleChannel::toString() const
  {
    DString aString ="Status      : ";
    aString        +=_status;
    aString        +="\n";
    aString        +="ChannelName : ";
    aString        +=_name;
    aString        +="\n";
    aString        +="ParentName : ";
    aString        +=_parentName;
    aString        +="\n";
    return aString;
  }
  ModuleChannel::ModuleChannel( const DString& name )
    :SerializeDataGettableObject(),_status("AllRight"),_parentName("NoParentName")
  {
    _setType();
    _setParentClasses();
    _name = name;
  }
  ModuleChannel::ModuleChannel( const ModuleChannel& right )
    :SerializeDataGettableObject(*((SerializeDataGettableObject*)&right)),_status(right._status),_parentName(right._parentName)
  {
  }
  ModuleChannel::~ModuleChannel()
  {
    _finalize();
  }
  const ModuleChannel& ModuleChannel::operator=( const ModuleChannel& right )
  {
    *((Object*)this) =      *((Object*)&right); 
    _name            =      right._name;
    _status          =      right._status;
    _parentName      =      right._parentName;
    return *this;
  }
  const DString&       ModuleChannel::getStatus() const
  {
    return _status;
  }
  void                 ModuleChannel::setStatus( const DString& status )
  {
    _status = status;
  }
  const DString&       ModuleChannel::getParentName() const
  {
    return _parentName;
  }
  void                 ModuleChannel::setParentName( const DString& parentName )
  {
    _parentName =    parentName;
  }
   const ByteArray     ModuleChannel::getData()
   {
      ByteArrayOutputStream aBAO;
      ObjectOutputStream    aOOS(&aBAO);
      DataElement aElement = read();
      aOOS.writeObject(aElement);
      aOOS.writeString(_parentName);
      return aBAO.toByteArray();
   }
  void           ModuleChannel::clear()
  {
    System::out.println("Clear !!!!!!"); 
  }
  void           ModuleChannel::update()
  {
  }
  void           ModuleChannel::initialize()
  {
  }
  DataElement    ModuleChannel::read()
  {
    DataElement aDataElement=1;
    aDataElement.setElementName(_name);
    return aDataElement;
  }
  void           ModuleChannel::write( const DataElement & data )
  {
  }
}
