#ifndef __DAQBuilderModuleChannel_HH_
#define __DAQBuilderModuleChannel_HH_
#include <DAQBuilderSerializeDataGettableObject.hh>
#include <Interface/DAQBuilderSerializeDataGettable.hh>

namespace DAQBuilder
{
  class DataElement;
  class ModuleChannel : 
  public SerializeDataGettableObject
  {
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const ModuleChannel& o ) const ;
    ModuleChannel( const DString& _channelName ="NoChannelName");
    ModuleChannel( const ModuleChannel& right );
    virtual ~ModuleChannel();
    virtual const ModuleChannel& operator=( const ModuleChannel& right );
  protected:
    DString                    _status;
    DString                    _parentName;
  public:
    virtual       void           clear();
    virtual       void           update();
    virtual       void           initialize();
    virtual       DataElement    read();
    virtual       void           write( const DataElement & data );
  public:
    virtual const DString        toString() const;
    const DString&       getStatus() const;
    void                 setStatus( const DString& _status);

    const DString&       getParentName() const;
    void                 setParentName( const DString& _parentName );

    virtual const ByteArray      getData();
  };
  inline void ModuleChannel::_setType()
  {
    _type ="ModuleChannel";
  }
  inline void ModuleChannel::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
  }
}
#endif
