#include <Modules/DAQBuilderReadoutList.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSystem.hh>
#include <DAQBuilderSerializableObject.hh>
#include <DAQBuilderSerializeDataGettableObject.hh>
#include <Modules/DAQBuilderModule.hh>
#include <Modules/DAQBuilderModuleChannel.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void              ReadoutList::_finalize()
  {
  }
  
  DBool  ReadoutList::equals( const Object * o ) const 
  {
     return true;
  }
  DBool  ReadoutList::equals( const ReadoutList& o ) const 
  {
     return true;
  }
  ReadoutList::ReadoutList()
    :SerializeDataGettableObject(),_eventCount(0)
  {
    _setType();
    _setParentClasses();
  }
  ReadoutList::ReadoutList( const ReadoutList& right )
    :std::map<DString,SmartPointer>(*((std::map<DString,SmartPointer>*)&right)),SerializeDataGettableObject(*((SerializeDataGettableObject*)&right)),_eventCount(right._eventCount),_datarecord(right._datarecord)
  {
  }
  ReadoutList::~ReadoutList()
  {
    _finalize();
  }
  const ReadoutList& ReadoutList::operator=( const ReadoutList& right )
  {
    *((Object*)this) = *((Object*)&right);
    *((std::map<DString,SmartPointer>*)this) = *((std::map<DString,SmartPointer>*)&right) ;
    _eventCount = right._eventCount;
    _datarecord = right._datarecord;
    return *this;
  }

  const DataSection ReadoutList::read()
  {
    DataSection aSection;
    aSection.setSectionName(_eventCount);
    for( std::map<DString,SmartPointer>::iterator iter = begin() ; 
                                          iter!= end();
                                          iter++)
     {
       ByteArrayInputStream aBAI( ((SerializeDataGettableObject*)(iter->second).get()) -> getData() );
       ObjectInputStream    aOIS(&aBAI);
       SerializableObject * tmp = aOIS.readObject();
       if(findParent("DataSegment",tmp)){
	 DataSegment aSegment = *((DataSegment*)tmp);
	 aSection.insertData(aSegment);
        }else if(findParent("DataElement",tmp)){
	 DataElement aElement = *((DataElement*)tmp);
	 DString  aParentName  = aOIS.readString(); 
	  std::map<DString,DataSegment>::iterator iter = aSection.find(aParentName);
	  if( iter != aSection.end() ){
	    (iter -> second).insertData(aElement);
	  }else if(iter == aSection.end()){ 
                DataSegment aSegment;
                aSegment.setSegmentName(aParentName); 
                aSegment.insertData(aElement);
                aSection.insertData(aSegment);
	  }
	}
     }
    _datarecord.insertData(aSection);
    _eventCount++;
    return aSection;
  }
  
  const DString               ReadoutList::toString() const 
  {
    DString aString;
    for(std::map<DString,SmartPointer>::const_iterator iter = begin();
                                                       iter!= end();
                                                       iter++)
    {
      aString +="( ";
      aString +=iter->first;
      aString +=",";
      aString +=(iter->second).toString();
      aString +=" )\n";
    }
    return aString;
  }  
  const DULong&                ReadoutList::getEventCount() const 
  {
    return _eventCount;
  }
  void                        ReadoutList::setEventCount( const DULong &  eventCount)
  {
    _eventCount = eventCount;
  }
  
  const ByteArray     ReadoutList::getData()
  {
    DataSection aSection = read();
    return aSection.serialize();
  }
  void               ReadoutList::installSource( SerializeDataGettableObject& source ) 
    throw (SameNameBindedException * )
  {
    DString aName = source.getName();
    SmartPointer aSP; 
    aSP  = source;  
    std::map<DString,SmartPointer>::const_iterator iter = find(aName);
    if( iter  != end())
      throw new SameNameBindedException(" ReadoutList::installSource( SerializeDataGettable& source )");
    else 
      insert(std::pair<DString,SmartPointer>(aName,aSP)); 
  }
  void ReadoutList::installSource( SerializeDataGettableObject* source ) 
      throw (SameNameBindedException * )
  {
    //std::cout<<source<<std::endl;
    DString aName = source->getName();
    SmartPointer aSP; 
    aSP  = source;  
    std::map<DString,SmartPointer>::const_iterator iter = find(aName);
    if( iter  != end())
      throw new SameNameBindedException(" ReadoutList::installSource( SerializeDataGettable& source )");
    else 
      insert(std::pair<DString,SmartPointer>(aName,aSP)); 
  }
}
