#ifndef __DAQBuilderReadoutList_HH_
#define __DAQBuilderReadoutList_HH_
#include <DAQBuilderSerializeDataGettableObject.hh>
#include <Interface/DAQBuilderSerializeDataGettable.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <Util/DAQBuilderSmartPointer.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>

namespace DAQBuilder
{
  class DataSection;
  class ReadoutList : public std::map<DString,SmartPointer> ,
  public SerializeDataGettableObject
  {
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const ReadoutList& o ) const ;
    ReadoutList();
    ReadoutList( const ReadoutList& right );
    virtual ~ReadoutList();
    virtual const ReadoutList& operator=( const ReadoutList& right );
  protected:
    DULong                  _eventCount;
    DataRecord              _datarecord;
  public:
    virtual const DataSection   read();
  public:
    const DString               toString() const ;

    virtual const ByteArray     getData();

    virtual void installSource( SerializeDataGettableObject& source ) 
      throw (SameNameBindedException * );
    virtual void installSource( SerializeDataGettableObject* source ) 
      throw (SameNameBindedException * );
  
    const DULong& getEventCount() const ;
    void          setEventCount( const DULong& _eventCount);

    const DataRecord& getDataRecord() const;
  };
  inline void ReadoutList::_setType()
  {
    _type ="ReadoutList";
  }
  inline void ReadoutList::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
  }
  inline  const DataRecord& ReadoutList::getDataRecord() const
  {
    return _datarecord;
  }
}
#endif
