#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/DAQBuilderSoftwareModule.hh>
#include <Util/DAQBuilderRandomEngine.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{   
  DBool  SoftwareModule::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
	 return false;
    return equals( *((SoftwareModule*)o));
  }
  DBool  SoftwareModule::equals( const SoftwareModule& o ) const 
  {
    return  equals(o);
  }
  SoftwareModule::SoftwareModule( const DString& moduleName )
    :Module(moduleName)
  {
    _setType();
    _setParentClasses();
  }
  SoftwareModule::SoftwareModule( const SoftwareModule& right )
    :Module(*((Module*)&right))
  {    
  }
  SoftwareModule::~SoftwareModule()
  {
    _finalize();
  }
  const SoftwareModule& SoftwareModule::operator=( const SoftwareModule& right )
  {
    *((Module*)this) =    *((Module*)&right);
    return *this;
  }
  void         SoftwareModule::waitInterrupt( const DataElement& waitTime  )
  {
    RandomEngine r;
    DULong random = ((DULong)r.getRandom());
    DULong aWTime = ((DULong)waitTime.getInt());
    DULong time =  random % aWTime;
    usleep( time ); 
    System::out.print("Interrupted wait time is : ");
    System::out.print(time);
    System::out.println(" [ usec ]");
  }
  DataElement  SoftwareModule::readLookAtMe()
  {
    return (DInt)1;
  }

}

