#ifndef __DAQBuilderSoftwareModule_HH_
#define __DAQBuilderSoftwareModule_HH_
#include <Modules/DAQBuilderModule.hh>

namespace DAQBuilder
{
  class SoftwareModule : public Module
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const SoftwareModule& o ) const ;
    SoftwareModule( const DString& _moduleName = "NoSoftwareModuleName");
    SoftwareModule( const SoftwareModule& right );
    virtual ~SoftwareModule();
    virtual const SoftwareModule& operator=( const SoftwareModule& right );
  public:
    /*virtual       void clear();
    virtual       void update();
    virtual       void initialize();
    virtual const DataSegment read();
    virtual const DataElement read( const DString& channel )
      throw (Exception * );
    virtual       void  write( const DataElement&  element  );
    virtual       void  write( const DString& channel , const DataElement&  element  )
      throw (Exception * );
    */
    virtual void         waitInterrupt( const DataElement& waitTime  );
    virtual DataElement  readLookAtMe();
  public:
  };
  inline void SoftwareModule::_setType()
  {
    _type ="SoftwareModule";
  }
  inline void SoftwareModule::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
  }
}
#endif
