#include <Modules/DAQBuilderSoftwareModuleChannel.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <System/DAQBuilderSystem.hh>
#include <Util/DAQBuilderRandomEngine.hh>

namespace DAQBuilder
{
  void              SoftwareModuleChannel::_finalize()
  {;}

  DBool  SoftwareModuleChannel::equals( const Object * o ) const 
  {
       if(!findParent(_type,o))
	 return false;
       return equals( *((SoftwareModuleChannel*)o));
  }
  DBool  SoftwareModuleChannel::equals( const SoftwareModuleChannel& o ) const 
  {
    return  equals(o);
  }
  SoftwareModuleChannel::SoftwareModuleChannel( const DString& channelName )
    :ModuleChannel(channelName)
  {
    _setType();
    _setParentClasses();
  }
  SoftwareModuleChannel::SoftwareModuleChannel( const SoftwareModuleChannel& right )
    :ModuleChannel(*((ModuleChannel*)&right))
  {
  }
  SoftwareModuleChannel::~SoftwareModuleChannel()
  {
    _finalize();
  }
  const SoftwareModuleChannel& SoftwareModuleChannel::operator=( const SoftwareModuleChannel& right )
  {
    *((ModuleChannel*)this) =      *((ModuleChannel*)&right); 
    return *this;
  }
  void           SoftwareModuleChannel::clear()
  {
    System::out.print(_parentName+_name);
    System::out.println(" : ClearChannel");
  }
  void           SoftwareModuleChannel::update()
  {
    System::out.print(_parentName+_name);
    System::out.println(" : UpdateChannel");
  }
  void           SoftwareModuleChannel::initialize()
  {
    System::out.print(_parentName+_name);
    System::out.println(" : InitializeChannel");
  }
  DataElement    SoftwareModuleChannel::read()
  {
    RandomEngine r;
    DataElement aDataElement = (DInt)r.getRandom() % 4096 ;
    aDataElement.setElementName(_name);
    return aDataElement;
  }
  void           SoftwareModuleChannel::write( const DataElement & data )
  {
    System::out.print(_parentName+_name);
    System::out.println("WriteData  : ");
    System::out.println(data);
  }
  
}
