#ifndef __DAQBuilderSoftwareModuleChannel_HH_
#define __DAQBuilderSoftwareModuleChannel_HH_
#include <Modules/DAQBuilderModuleChannel.hh>

namespace DAQBuilder
{
  class SoftwareModuleChannel : public ModuleChannel
  {
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const SoftwareModuleChannel& o ) const ;
    SoftwareModuleChannel( const DString& _channelName="NoChannelName" );
    SoftwareModuleChannel( const SoftwareModuleChannel& right );
    virtual ~SoftwareModuleChannel();
    virtual const SoftwareModuleChannel& operator=( const SoftwareModuleChannel& right );
  public:
    virtual       void           clear();
    virtual       void           update();
    virtual       void           initialize();
    virtual       DataElement    read();
    virtual       void           write( const DataElement & data );
  };
  inline void SoftwareModuleChannel::_setType()
  {
    _type ="SoftwareModuleChannel";
  }
  inline void SoftwareModuleChannel::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("ModuleChannel");
  }
}
#endif
