#include <Modules/DAQBuilderSoftwareSwitchRegister.hh>
#include <Modules/DAQBuilderSoftwareModuleChannel.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{   
  DBool  SoftwareSwitchRegister::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
	 return false;
    return equals( *((SoftwareSwitchRegister*)o));
  }
  DBool  SoftwareSwitchRegister::equals( const SoftwareSwitchRegister& o ) const 
  {
    return  equals(o);
  }
  SoftwareSwitchRegister::SoftwareSwitchRegister( const DString& moduleName , const DULong& numChannels )
    :SoftwareModule(moduleName),_numChannels(numChannels)
  {
    _setType();
    _setParentClasses();
    for( DULong i =  0 ;  i< _numChannels ; i ++)
      {
	DString tmp ;//= "Ch";
	tmp        += String::digitToString(i);
        installChannel( *((ModuleChannel*) new SoftwareModuleChannel(tmp)));
      }
  }
  SoftwareSwitchRegister::SoftwareSwitchRegister( const SoftwareSwitchRegister& right )
    :SoftwareModule(*((SoftwareModule*)&right)),_numChannels(right._numChannels)
  {    
  }
  SoftwareSwitchRegister::~SoftwareSwitchRegister()
  {
    _finalize();
  }
  const SoftwareSwitchRegister& SoftwareSwitchRegister::operator=( const SoftwareSwitchRegister& right )
  {
    *((SoftwareModule*)this) =    *((SoftwareModule*)&right);
    return *this;
  }
}

