#ifndef __DAQBuilderSoftwareSwitchRegister_HH_
#define __DAQBuilderSoftwareSwitchRegister_HH_
#include <Modules/DAQBuilderSoftwareModule.hh>

namespace DAQBuilder
{
  class SoftwareSwitchRegister : public SoftwareModule
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DULong                     _numChannels;
  public :
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const SoftwareSwitchRegister& o ) const ;
  public:
    SoftwareSwitchRegister( const DString& _moduleName = "NoSoftwareSwitchRegisterName" , const DULong& _numChannels = 16);
    SoftwareSwitchRegister( const SoftwareSwitchRegister& right );
    virtual ~SoftwareSwitchRegister();
    virtual const SoftwareSwitchRegister& operator=( const SoftwareSwitchRegister& right );
  };
  inline void SoftwareSwitchRegister::_setType()
  {
    _type ="SoftwareSwitchRegister";
  }
  inline void SoftwareSwitchRegister::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
    _parentClasses.insert("SerializeDataGettableObject");
    _parentClasses.insert("Module");
    _parentClasses.insert("SoftwareModule");
  }
}
#endif
