#include <Primitives/DAQBuilderBoolean.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  Cloneable *                Boolean::clone() const
  {
    return (Cloneable*)new Boolean(*this);
  }
  Boolean::Boolean()
    :Number((DBool)true)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Boolean::Boolean(const DBool& value)
    :Number((DBool)value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Boolean::Boolean( const Boolean & value )
    :Number((Number*)&value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Boolean::Boolean( const Number  & value )
    :Number(value)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  Boolean::Boolean( const DString  & value )
    :Number((DBool)true)
  {
    _eType=etBool;
    String tmp(value);
    if( tmp.equalsIgnoreCase("true"))
      _value._boolValue=true;
    else
      _value._boolValue=false;
  }
  Boolean::~Boolean()
  {
    _finalize();
  }
}
