#ifndef __DAQBuilderBoolean_HH__
#define __DAQBuilderBoolean_HH__
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder 
{
  class Boolean : public Number
  {
  protected : 
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    virtual Cloneable *                clone() const ;
  public :
    Boolean();
    Boolean( const DBool&     value );
    Boolean( const Boolean & value );
    Boolean( const Number  & value );
    Boolean( const DString & value  );
    virtual ~Boolean();
  public :
    const DBool &                    get() const ;
    void                             set(const DBool & b );
    void                             toOpposite();
    virtual DBool   equlas( const Object * o ) const;
    Boolean&              operator= ( const Boolean  & right );
    Boolean&              operator= ( const DBool    & right );
  };
  inline void                            Boolean::toOpposite()
  {
    _value._boolValue = !(_value._boolValue);
  }
  inline void          Boolean::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Number");
  }
  inline void      Boolean::set(const DBool & b )
  {
    _value._boolValue=b;
  }
  inline const DBool&        Boolean::get() const 
  {
    return getValue()._boolValue;
  }
  inline void         Boolean::_setType() 
  {
     this -> _type = "Boolean";
  }
  inline DBool         Boolean::equlas( const Object * o ) const
  {
    if(!findParent("Number",o))
      return false;
    return getValue()._boolValue == ((Boolean*)o)->getValue()._boolValue;
  }
  inline Boolean& Boolean::operator=( const Boolean& right )
  {
    *((Number*)this) = *((Number*)&right);
    return *this;
  }
  inline Boolean&           Boolean::operator= ( const DBool    & right )
  {
    _eType=etBool;
    _value._boolValue=right;
    return *this;
  }
}
#endif
